
function colorGradient(levels, cstr1, cstr2) {
	var i, j, values, inc, grad, col;
	
	values1 = new Array();
	values2 = new Array();
	for (i = 0; i <= 2; i++) {
		values1[i] = parseInt(cstr1.substring(i*2+1,i*2+3), 16);
		values2[i] = parseInt(cstr2.substring(i*2+1,i*2+3), 16);
	}
	
	inc = new Array();
	inc[0] = (values2[0] - values1[0]) / levels;
	inc[1] = (values2[1] - values1[1]) / levels;
	inc[2] = (values2[2] - values1[2]) / levels;
	
	grad = new Array();
	for (i = 0; i < levels; i++) {
		col = new Array();
		for (j = 0; j <= 2; j++) {
			col[j] = Math.round(values1[j] + i*inc[j]);
		}
		grad[i] = assembleColor(col);
	}
	
	return grad;
}

function assembleColor(rgbArray) {
	var i, color, hex;
	
	color = '#';
	for (i = 0; i <= 2; i++) {
    if (rgbArray[i] > 255) { rgbArray[i] = 255; }
		hex = rgbArray[i].toString(16);
		if (hex.length == 1) { hex = '0' + hex; }
		color += hex;
	}
	
	return color;
}

function colorHue(cstr) {
}

function colorSaturation(cstr) {
	var maxmin = colorMaxMin(cstr);
	
	return (100/maxmin[0]) * maxmin[1];
}

function colorValue(cstr) {
	var maxmin = colorMaxMin(cstr);
	
	return (100/255) * maxmin[0];
}

function colorMaxMin(cstr) {
	var maxcol, mincol, i, val;
	
	maxcol = 0;
	mincol = 255;
	for (i = 1; i <= 6; i+=2) {
		val = parseInt(cstr.substring(i,i+2), 16);
		if (val > maxcol) { maxcol = val; }
		if (val < mincol) { mincol = val; }
	}
	
	return new Array(maxcol, mincol);
}
